/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

class mx_driver:public IOService
{
  OSDeclareDefaultStructors (mx_driver);

 private:
  int loaded_ok;
  IOWorkLoop *workLoop;
  IOMemoryMap *pcimap;
  IOInterruptEventSource *interruptSource;
  IOTimerEventSource *timerSource;	

  static void interruptOccurred(OSObject *obj, IOInterruptEventSource *src,
				int count) {
    mx_driver *me;
    me = OSDynamicCast(mx_driver, obj);
    if (me) {
      mx_common_interrupt(me->is);
    }
  };

 public:
  IOPCIDevice *pciNub;
  mx_instance_state_t *is;

  /* override methods */
  virtual bool start(IOService *provider);
  virtual void stop(IOService *provider);
  virtual void free();
  virtual bool createWorkLoop();
  virtual IOWorkLoop *getWorkLoop();
  virtual void joinPMtree(IOService *driver);
};
